"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * Promise-based replacement for setTimeout / clearTimeout.
 */
var _require = require('./utils'),
    promiseFinally = _require.promiseFinally,
    toError = _require.toError;

module.exports =
/*#__PURE__*/
function () {
  _createClass(Timeout, null, [{
    key: "set",
    value: function set(delay, rejectReason) {
      return new Timeout().set(delay, rejectReason);
    }
  }, {
    key: "wrap",
    value: function wrap(promise, delay, rejectReason) {
      return new Timeout().wrap(promise, delay, rejectReason);
    }
  }]);

  function Timeout() {
    _classCallCheck(this, Timeout);

    this._id = null;
    this._delay = null;
  }

  _createClass(Timeout, [{
    key: "set",
    value: function set(delay) {
      var _this = this;

      var rejectReason = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      return new Promise(function (resolve, reject) {
        _this.clear();

        var fn = rejectReason ? function () {
          return reject(toError(rejectReason));
        } : resolve;
        _this._id = setTimeout(fn, delay);
        _this._delay = delay;
      });
    }
  }, {
    key: "wrap",
    value: function wrap(promise, delay) {
      var _this2 = this;

      var rejectReason = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
      var wrappedPromise = promiseFinally(promise, function () {
        return _this2.clear();
      });
      var timer = this.set(delay, rejectReason);
      return Promise.race([wrappedPromise, timer]);
    }
  }, {
    key: "clear",
    value: function clear() {
      if (this._id) {
        clearTimeout(this._id);
      }
    }
  }, {
    key: "id",
    get: function get() {
      return this._id;
    }
  }, {
    key: "delay",
    get: function get() {
      return this._delay;
    }
  }]);

  return Timeout;
}();